using System;

namespace Server.Items
{
	public class CharmOfLuck : Item
	{
		[Constructable]
		public CharmOfLuck() : this( 1 )
		{
		}

		[Constructable]
		public CharmOfLuck( int amount ) : base( 9908 )
		{
			Weight = 0.001;
			Hue = 2577;
			Stackable = true;
			Amount = amount;
			Name = "charm of luck";
// 			LootType = LootType.Blessed;
		}

		public CharmOfLuck( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}